﻿var language;
var SYNC_ACTION = false;

function mouseOverSyn(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_hover.png)";
	}
}
function mouseOutSyn(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_normal.png)";
	}
}

function getSNTPStatus()
{
	var listValue = parseInt(document.getElementById("SntpStatus").value);
	return listValue;
}

function DisableApplyButton(bDisable)
{
    disabledButton(document.getElementById("ApplySntp"), bDisable);
}

function handleSyncStatus()
{
	DisableApplyButton(false);
	DisableSntpServerFields("SntpMainIPRow","SntpBackupIPRow","UtcOffset","SntpSyncIntRow","SntpSyncTORow","SntpLastSyncRow","SynchronizeNow");
}

function DisableSntpServerFields()
{
	var i,v,obj;
	var args = DisableSntpServerFields.arguments;

	if(getSNTPStatus() == 0)
	{
		v = "none";
	}
	else if(getSNTPStatus() == 1)
	{
		v = "";
	}

	for(i = 0; i < (args.length); i++)
	{
		obj = document.getElementById(args[i]);
		if(obj != null)
		{
			if(args[i] == "SynchronizeNow")
			{
				if(parent.group == USER)
				{
					obj.style.display = "none";
				}
				else
				{
					obj.style.display = v;
				}
			}
			else
			{
				obj.style.display = v;
			}
		}
	}
}

function getMonthValue(currentTime)
{
	var monthArr = new Array("JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC");
	var index;
	var timeArr = currentTime.split(" ");
	var sMonth = timeArr[1].toUpperCase();

	for(index = 0; index < 12; index++)
	{
		if(sMonth == monthArr[index])
		{
			return (index + 1);
		}
	}
	return -1;
}

function getDayValue(currentTime)
{
	var dayArr = new Array("MON","TUE","WED","THU","FRI","SAT","SUN");
	var index;
	dayArr = currentTime.split(" ");
	var sDay = dayArr[0].toUpperCase();
	document.getElementById("CurrentTimeDate").value = parseInt(dayArr[2],10);

	for(index = 0; index < 7; index++)
	{
		if(sDay == dayArr[index])
		{
			return (index + 1);
		}
	}
	return -1;
}

function PopulateModifiedClockPage(response_array)
{
    var sCurrTime1 = response_array[1];
    var sCurrTimeHour = response_array[2];
    var sCurrTimeMins = response_array[3];
	var sCurrTimeSecs = response_array[4];
    var sCurrTimeYear = response_array[5];

    if(language == 0)
	{
		document.getElementById("currTime").innerHTML = sCurrTime1 + " " + sCurrTimeHour + ":" + sCurrTimeMins + ":" + sCurrTimeSecs + " " + sCurrTimeYear;
	}
	else
	{
		document.getElementById("currTime").innerHTML = sCurrTimeYear + "年" + sCurrTime1 + " " + sCurrTimeHour + ":" + sCurrTimeMins + ":" + sCurrTimeSecs;
	}
    document.getElementById("CurrentTimeHour").value = sCurrTimeHour;
    document.getElementById("CurrentTimeMinute").value = sCurrTimeMins;
    document.getElementById("CurrentTimeSecond").value = sCurrTimeSecs;
    document.getElementById("CurrentTimeYear").value = sCurrTimeYear;
    document.getElementById("CurrentTimeMonth").value = getMonthValue(sCurrTime1);
    document.getElementById("CurrentTimeDay").value = getDayValue(sCurrTime1);
    var sSntpStatus = response_array[6];
    var nSntpStatus = parseInt(sSntpStatus, 10);

	document.getElementById("SntpStatus").value = nSntpStatus;

    var sSntpMainServerIP = response_array[7];
    document.getElementById("SntpMainServerIP").value = sSntpMainServerIP;

    var sSntpBackupServerIP = response_array[8];
    document.getElementById("SntpBackupServerIP").value = sSntpBackupServerIP;

    var sUtcOffset = response_array[9];
    var nUtcOffset = parseInt(sUtcOffset);
    document.getElementById("UtcOffsetList").value = nUtcOffset;

    var sSyncInterval = response_array[10];
    document.getElementById("SyncInterval").value = sSyncInterval;

    var sSyncTimeout = response_array[11];
    document.getElementById("SyncTimeout").value = sSyncTimeout;

    var sLastSyncTime = response_array[12];
    document.getElementById("LastSyncTime").innerHTML = sLastSyncTime;

    document.getElementById("prevTimeZone").value = response_array[9];

    DisableSntpServerFields("SntpMainIPRow","SntpBackupIPRow","UtcOffset","SntpSyncIntRow","SntpSyncTORow","SntpLastSyncRow","SynchronizeNow");
}

function GetClockValues()
{
	var xmlhttp = getHTTPObject();
	var response;
	var getParams = "type=19&cmd=1&getSystemClock=1&language=" + language;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, - bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			var response_array = response.split("&");
			PopulateModifiedClockPage(response_array);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function updateClockLocal()
{
    var nTimeSec = document.getElementById("CurrentTimeSecond").value;
    var nTimeMin = document.getElementById("CurrentTimeMinute").value;
    var nTimeHrs = document.getElementById("CurrentTimeHour").value;

    var tmpSec = "";
    var tmpMin = "";
    var tmpHrs = "";

    if((++nTimeSec) == 60)
    {
        nTimeSec = 0;
        if((++nTimeMin) == 60)
        {
            nTimeMin = 0;
            if((++nTimeHrs) == 24)
            {
                nTimeHrs = 0;
				//Get the new day information from the board on midnight
				GetClockValues(); 
			}
        }
    }

    var prevTime = document.getElementById("currTime").innerHTML;
    var timearr = prevTime.split(" ");

    if(parseInt(nTimeSec,10) < 10)
	{
    	tmpSec = "0" + (parseInt(nTimeSec,10)); //*10) / 10;
	}
    else
	{
    	tmpSec = nTimeSec;
	}
    if(parseInt(nTimeMin,10) < 10)
	{
    	tmpMin = "0" + (parseInt(nTimeMin,10)); //*10) / 10;
	}
    else
	{
    	tmpMin = nTimeMin;
	}
    if(parseInt(nTimeHrs,10) < 10)
	{
    	tmpHrs = "0" + (parseInt(nTimeHrs,10)); //*10) / 10;
	}
	else
	{
		tmpHrs = nTimeHrs;
	}
	if((bd.browser == "IE") && (language == 1))
	{
		timearr[2] = tmpHrs + ":" + tmpMin + ":" + tmpSec;
	}
	else
	{
		timearr[3] = tmpHrs + ":" + tmpMin + ":" + tmpSec;
	}

    document.getElementById("currTime").innerHTML = timearr.join(" ");
    document.getElementById("CurrentTimeSecond").value = nTimeSec;
    document.getElementById("CurrentTimeMinute").value = nTimeMin;
    document.getElementById("CurrentTimeHour").value = nTimeHrs;
}

function clearNewTimeFields()
{
	document.getElementById("NewTimeYear").value = "";
	document.getElementById("NewTimeMonth").value = "";
	document.getElementById("NewTimeDay").value = "";
	document.getElementById("NewTimeHour").value = "";
	document.getElementById("NewTimeMinute").value = "";
	document.getElementById("NewTimeSecond").value = "";
}

window.onload = function()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	var apply = document.getElementById("ApplySntp");
	applyDispay(parent.group, apply);
	language = document.getElementById("language").value;
	DisableApplyButton(true);
	GetClockValues();
	setInterval("updateClockLocal()",1000);
	document.getElementById("SntpStatus").value = 1;
	
	clearNewTimeFields();
	document.body.style.cursor = "auto";
	window.status = "Done";
//  This line moved to last since the visibility property is not supported in IE
	DisableSntpServerFields("SntpMainIPRow","SntpBackupIPRow","UtcOffset","SntpSyncIntRow","SntpSyncTORow","SntpLastSyncRow","SynchronizeNow");
}

function ResetSntp_onclick()
{
	document.body.style.cursor = "wait";
	window.status = "Resetting the values, please wait...";

	DisableApplyButton(true);
	GetClockValues();
	clearNewTimeFields();

	document.body.style.cursor = "auto";
	window.status = "Done";
}


function GatherSyncFieldValues()
{
    var sSntpMainServerIP = document.getElementById("SntpMainServerIP").value;
    var sSntpBackupServerIP = document.getElementById("SntpBackupServerIP").value;
    var sUtcOffset = document.getElementById("UtcOffsetList").value;
    var sSyncInterval = document.getElementById("SyncInterval").value;
    var sSyncTimeout = document.getElementById("SyncTimeout").value;
	var sSntpStatus	 = document.getElementById("SntpStatus").value;

    var sValueString = "," + sSntpMainServerIP + "," + sSntpBackupServerIP;
    sValueString += "," + sUtcOffset + "," + sSyncInterval + "," + sSyncTimeout + "," + sSntpStatus;

    return sValueString;
}

function GatherFieldValues()
{
    var sNewTimeYear = document.getElementById("NewTimeYear").value;
    if(sNewTimeYear.length == 0)
	{
		sNewTimeYear = document.getElementById("CurrentTimeYear").value;
	}

    var sNewTimeMonth = document.getElementById("NewTimeMonth").value;
    if(sNewTimeMonth.length == 0)
	{
		sNewTimeMonth = document.getElementById("CurrentTimeMonth").value;
	}
		
    var sNewTimeDay = document.getElementById("NewTimeDay").value;
    if(sNewTimeDay.length == 0)
	{
		sNewTimeDay = document.getElementById("CurrentTimeDate").value;
	}

    var sNewTimeHour = document.getElementById("NewTimeHour").value;
    if(sNewTimeHour.length == 0)
	{
		sNewTimeHour = document.getElementById("CurrentTimeHour").value;
	}

    var sNewTimeMinute = document.getElementById("NewTimeMinute").value;
    if(sNewTimeMinute.length == 0)
	{
		sNewTimeMinute = document.getElementById("CurrentTimeMinute").value;
	}

    var sNewTimeSecond = document.getElementById("NewTimeSecond").value;
    if(sNewTimeSecond.length == 0)
	{
		sNewTimeSecond = document.getElementById("CurrentTimeSecond").value;
	}

    var sSntpStatus = document.getElementById("SntpStatus").value;
    var sSntpMainServerIP = document.getElementById("SntpMainServerIP").value;
    var sSntpBackupServerIP = document.getElementById("SntpBackupServerIP").value;
    var sUtcOffset = document.getElementById("UtcOffsetList").value;
    var sSyncInterval = document.getElementById("SyncInterval").value;
    var sSyncTimeout = document.getElementById("SyncTimeout").value;
    var sPrevTimeZone = document.getElementById("prevTimeZone").value;

    var sValueString = "," + sNewTimeYear + "," + sNewTimeMonth + "," + sNewTimeDay;
    sValueString += "," + sNewTimeHour + "," + sNewTimeMinute + "," + sNewTimeSecond;
    sValueString += "," + sSntpStatus + "," + sSntpMainServerIP + "," + sSntpBackupServerIP ;
    sValueString += "," + sUtcOffset + "," + sSyncInterval + "," + sSyncTimeout + "," + sPrevTimeZone;

	return sValueString;
}

function FormSynchString()
{
    var sSyncString = "SYNC" + GatherSyncFieldValues();
    return sSyncString;
}

function FormUpdateString()
{
    var sUpdateString = "UPDATE" + GatherFieldValues();
    return sUpdateString;
}

/**************************************************************************
    Name: SetClockData(sValueString)

    Arg:  sValueString

    This function is used to pass updated values to the backend CGI.
    It is used for both UPDATE and CLOCK SYNC operations.
***************************************************************************/

function SetClockData(sValueString)
{
	var getParams = "type=19&cmd=2&clockSetString=" + sValueString;

	var xmlhttp = getHTTPObject();	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			window.status = "Done";
			document.body.style.cursor = "auto";
			if(SYNC_ACTION == false)
			{
				if(language == 0)
				{
					alert("Clock configuration updated successfully.");
				}
				else
				{
					alert("时钟参数已设置成功。");
				}
			}
			else
			{
				SYNC_ACTION = false;
			}
			document.getElementById("SynchronizeNow").disabled = false;
			GetClockValues();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function SynchronizeNow_onclick()
{
	SYNC_ACTION = true;
	if(ValidateSntp() == false)
	{
		return false;
	}
	document.body.style.cursor = "wait";
	document.getElementById("SynchronizeNow").disabled = true;
	window.status = "Synchronizing with SNTP server, please wait...";

	var sSyncString = FormSynchString();
	SetClockData(sSyncString);
	DisableApplyButton(true);
	document.body.style.cursor = "auto";
	window.status = "Done";
}

function ApplySntp_onclick()
{
	var flag;
	var sUpdateString;

	if(ValidateSntp() == false)
	{
		return false;
	}

	flag = ValidateClkParam();
	if(flag == false)
	{
		return false;
	}

	document.body.style.cursor = "wait";
	window.status = "Updating clock, please wait...";

	DisableApplyButton(true);
  	sUpdateString = FormUpdateString();

	/* Adding the Change Status flag */
	if(flag == 63)
	{
		sUpdateString += "," + 0;
	}
	else
	{
		sUpdateString += "," + 1;
	}
  	SetClockData(sUpdateString);
  	clearNewTimeFields();

  	document.body.style.cursor = "auto";
	window.status = "Done";
}


function checkLeapYear(data)
{
	data = parseInt(data,10);
	if((data % 4) == 0)
	{
		if((data % 100) != 0)
		{
			return true;
		}
		else
		{
			if((data % 400) == 0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
	}
	return false;
}

function ValidateSntp()
{
	for(var i = 0; i < 4; i++)
	{
		var id = i + 1;
		if(ValidateThisSntp(id) == false)
		{
			 return false;
		}
	}
	return true;
}

function ValidateThisSntp(id)
{
	var obj;
	if(getSNTPStatus() == 1)
	{
		if(id == 1)
		{
			obj = document.getElementById("SntpMainServerIP");
			if(Validate_IP_Format(obj.value) == false)
			{
				if(language == 0)
				{
					alert("Please input a valid IP address for main SNTP server.");
				}
				else
				{
					alert("请输入正确的IP地址作为主SNTP服务器地址。");
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
		}
		else if(id == 2)
		{
			obj = document.getElementById("SntpBackupServerIP");
			if(Validate_IP_Format(obj.value) == false)
			{
				if(language == 0)
				{
					alert("Please input a valid IP address for backup SNTP server.");
				}
				else
				{
					alert("请输入正确的IP地址作为备份SNTP服务器地址。");
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
		}
		else if(id == 3)
		{
			obj = document.getElementById("SyncInterval");
			if(validateNumber(obj.value) == false)
			{
				if(language == 0)
				{
					alert("Invalid number. Please enter a valid numeric value for SYNC Interval.");
				}
				else
				{
					alert("无效的数字，请输入一个有效的时钟同步间隔。");
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
			if((obj.value < 1) || (obj.value > 65535))
			{
				if(language == 0)
				{
					alert("Valid range for SYNC Interval is 1 - 65535.");
				}
				else
				{
					alert("时钟同步间隔的范围是1 - 65535。");
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
		}
		else if(id == 4)
		{
			obj = document.getElementById("SyncTimeout");
			if(validateNumber(obj.value) == false)
			{
				if(language == 0)
				{
					alert("Invalid number. Please enter a valid numeric value for SYNC Timeout.");
				}
				else
				{
					alert("无效的数字，请输入一个有效的时钟同步等待时间。");
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
			if((obj.value < 1) || (obj.value > 65535))
			{
				if(language == 0)
				{
					alert("Valid range for SYNC Timeout is 1 - 65535.");
				}
				else
				{
					alert("时钟同步等待时间的范围是1 - 65535。");
				}
				setTimeout(function () {obj.focus()}, 50);
				obj.select();
				return false;
			}
		}
	}
	return true;
}

function validateYear(yearCtrl)
{
	retValue = true;
	yearValue = yearCtrl.value;
	if(validateNumber(yearValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Year.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的年。");
		}
		retValue = false
	}

	if((parseInt(yearValue) < 1970) || (parseInt(yearValue) > 9999))
	{
		if(language == 0)
		{
			alert("Valid range for Year is 1970 - 9999.");
		}
		else
		{
			alert("年的范围是1970 - 9999。");
		}
		retValue = false;
	}
	
	if(retValue == false)
	{
		setTimeout(function () {yearCtrl.focus()}, 50);
		yearCtrl.select();
	}

	return retValue;
}

function validateMonth(monthCtrl)
{
	retValue = true;
	monthValue = monthCtrl.value;

	if(validateNumber(monthValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Month.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的月。");
		}
		retValue = false
	}

	if((parseInt(monthValue) < 1) || (parseInt(monthValue) > 12))
	{
		if(language == 0)
		{
			alert("Valid range for Month is 1 - 12.");
		}
		else
		{
			alert("月的范围是1 - 12。");
		}
		retValue = false;
	}

	if(retValue == false)
	{
		setTimeout(function () {monthCtrl.focus()}, 50);
		monthCtrl.select();
	}

	return retValue;
}

function validateDate(dateCtrl)
{
	retValue = true;
	dateValue = dateCtrl.value;
	if(validateNumber(dateValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Date.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的日。");
		}
		retValue = false
	}
//	In future, date should be validated w.r.t month value
	if((parseInt(dateValue) < 1) || (parseInt(dateValue) > 31))
	{
		if(language == 0)
		{
			alert("Valid range for Date is 1 - 31.");
		}
		else
		{
			alert("日的范围是1 - 31。");
		}
		retValue = false;
	}

	if(retValue == false)
	{
		setTimeout(function () {dateCtrl.focus()}, 50);
		dateCtrl.select();
	}

	return retValue;
}

function validateHour(hourCtrl)
{
	retValue = true;
	hourValue = hourCtrl.value;

	if(validateNumber(hourValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Hour.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的时。");
		}
		retValue = false
	}

	if((parseInt(hourValue) < 0) || (parseInt(hourValue) > 23))
	{
		if(language == 0)
		{
			alert("Valid range for Hour is 0 - 23.");
		}
		else
		{
			alert("时的范围是0 - 23。");
		}
		retValue = false;
	}

	if(retValue == false)
	{
		setTimeout(function () {hourCtrl.focus()}, 50);
		hourCtrl.select();
	}

	return retValue;
}

function validateMinutes(minCtrl)
{
	retValue = true;
	minValue = minCtrl.value;

	if(validateNumber(minValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Minute.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的分。");
		}
		retValue = false
	}

	if((parseInt(minValue) < 0) || (parseInt(minValue) > 59))
	{
		if(language == 0)
		{
			alert("Valid range for Minute is 0 - 59.");
		}
		else
		{
			alert("分的范围是0 - 59。");
		}
		retValue = false;
	}

	if(retValue == false)
	{
		setTimeout(function () {minCtrl.focus()}, 50);
		minCtrl.select();
	}

	return retValue;
}

function validateSeconds(secCtrl)
{
	retValue = true;
	secValue = secCtrl.value;

	if(validateNumber(secValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Second.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的秒。");
		}
		retValue = false
	}

	if((parseInt(secValue) < 0) || (parseInt(secValue) > 59))
	{
		if(language == 0)
		{
			alert("Valid range for Second is 0 - 59.");
		}
		else
		{
			alert("秒的范围是0 - 59。");
		}
		retValue = false;
	}

	if(retValue == false)
	{
		setTimeout(function () {secCtrl.focus()}, 50);
		secCtrl.select();
	}

	return retValue;
}

function validateClkDay(obj)
{
	var number_flag;
    var sNewTime;
    
	sNewTime = obj.value;
	number_flag = parseInt(sNewTime, 10);;
	if(validateDate(obj) != true)
	{
		return false;
	}
	else
	{
		/* Check the year is leap year or not */
		var NewMonth = parseInt(document.getElementById("NewTimeMonth").value, 10);
		var NewYear  = parseInt(document.getElementById("NewTimeYear").value, 10);
		switch(NewMonth)
		{
			case 1:
			case 3:
			case 5:
			case 7:
			case 8:
			case 10:
			case 12:
				/* Check the max value */
				if(number_flag > 31)
				{
					if(language == 0)
					{
						alert("Number of days in this month is no greater than 31.");
					}
					else
					{
						alert("该月的天数不能超过31天。");
					}
					setTimeout(function () {obj.focus()}, 50);
					obj.select();
					return false;
				}
				break;
			case 2:
				/* Febraury Leap year */
				if(checkLeapYear(NewYear) == true)
				{
					if(number_flag > 29)
					{
						if(language == 0)
						{
							alert("Number of days in this month is no greater than 29.");
						}
						else
						{
							alert("该月的天数不能超过29天。");
						}
						setTimeout(function () {obj.focus()}, 50);
						obj.select();
						return false;
					}
				}
				else
				{
					if(number_flag > 28)
					{
						if(language == 0)
						{
							alert("Number of days in this month is no greater than 28.");
						}
						else
						{
							alert("该月的天数不能超过28天。");
						}
						setTimeout(function () {obj.focus()}, 50);
						obj.select();
						return false;
					}
				}
				break;
			default:
				/* Check the max value */
				if(number_flag > 30)
				{
					if(language == 0)
					{
						alert("Number of days in this month is no greater than 30.");
					}
					else
					{
						alert("该月的天数不能超过30天。");
					}
					setTimeout(function () {obj.focus()}, 50);
					obj.select();
					return false;
				}
				break;
		}
	}
	return true;	
}

function  ValidateClkParam()
{
	var shift_flag;
	var status_flag = 0;
	var obj;
    var sNewTime;

    /* Validate the new time clock fields */
    obj = document.getElementById("NewTimeYear");
	sNewTime = obj.value;
	if(sNewTime.length == 0)
	{
		shift_flag = 1;
		status_flag = status_flag | shift_flag;
	}
	else
	{
		if(validateYear(obj) != true)
		{
			return false;
		}
	}

	obj = document.getElementById("NewTimeMonth");
	sNewTime = obj.value;
	if(sNewTime.length == 0)
	{
		shift_flag = 1 << 1;
		status_flag = status_flag | shift_flag;
	}
    else
	{
		if(validateMonth(obj) != true)
		{
			return false;
		}
	}

	obj = document.getElementById("NewTimeDay");
	sNewTime = obj.value;
	if(sNewTime.length == 0)
	{
		shift_flag = 1 << 2;
		status_flag = status_flag | shift_flag;
	}
	else
	{
		if(validateClkDay(obj) != true)
		{
			return false;
		}
	}
	
    obj = document.getElementById("NewTimeHour");
	sNewTime = obj.value;
	if(sNewTime.length == 0)
    {
		shift_flag = 1 << 3;
		status_flag = status_flag | shift_flag;
	}
	else
	{
		if(validateHour(obj) != true)
		{
			return false;
		}
	}

	obj = document.getElementById("NewTimeMinute");
	sNewTime = obj.value;
	if(sNewTime.length == 0)
    {
		shift_flag = 1 << 4;
		status_flag = status_flag | shift_flag;
	}
	else
	{
		if(validateMinutes(obj) != true)
		{
			return false;
		}
	}

	obj = document.getElementById("NewTimeSecond");
	sNewTime = obj.value;
	if(sNewTime.length == 0)
    {
		shift_flag = 1 << 5;
		status_flag = status_flag | shift_flag;
	}
	else
	{
		if(validateSeconds(obj) != true)
		{
			return false;
		}
	}

	if((status_flag != 63) && (status_flag != 0))
	{
		if(language == 0)
		{
			alert("Please input the new time consist of date and time integrally.");
		}
		else
		{
			alert("请输入完整的日期和时间。");
		}
		return false;
	}

	if(status_flag == 63)
	{
		return 63;
	}
	else
	{
		return 2;
	}
}
